
/****** Object:  StoredProcedure [dbo].[P_EST_PRECIFICACAO_GRP_PRECO]    Script Date: 02/11/2014 08:46:04 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PRECIFICACAO_GRP_PRECO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT]
GO
 
CREATE PROCEDURE P_EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT (@CD_EMP INT, @DT_REF AS DATETIME)
WITH  ENCRYPTION AS

/*******************************************************************************************************************/
-- Remove as tabelas temporarias
/*******************************************************************************************************************/
	IF  OBJECT_ID('TEMPDB.DBO.#TMP_ENT') IS NOT NULL
	BEGIN
	DROP TABLE #TMP_ENT
	END

	IF  OBJECT_ID('TEMPDB.DBO.#TMP_TBL_ENT') IS NOT NULL
	BEGIN
	DROP TABLE #TMP_TBL_ENT
	END

	IF  OBJECT_ID('TEMPDB.DBO.#TBL_PROD_DPL') IS NOT NULL
	BEGIN
	DROP TABLE #TBL_PROD_DPL
	END

	IF  OBJECT_ID('TEMPDB.DBO.#TBL_PROD_DPL') IS NOT NULL
	BEGIN
	DROP TABLE #TBL_PROD_DPL
	END
	  
	BEGIN TRY DROP TABLE EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT_BKP END TRY
	BEGIN CATCH END CATCH; 

	BEGIN TRY DROP TABLE EST_PROD_ENT_GRP_ECON_BKP END TRY
	BEGIN CATCH END CATCH;

/*******************************************************************************************************************/
--Cria base de ultimas entradas
/*******************************************************************************************************************/
 
	SELECT   
		CD_PROD,
		MAX(DT_ENT) DT_ULT_ENT 
		INTO #TMP_ENT
	FROM 
		V_EST_NF_ENT
	WHERE
		CD_EMP=@CD_EMP
		AND TP_MOV_OP_TRANSA = 0
		AND TP_MOV=0 
		AND DT_ENT > @DT_REF
	GROUP BY   
		CD_PROD;
   
	SELECT 
		A.CD_EMP,
		A.CD_FILIAL,
		A.CD_NF,
		A.CD_PROD,
		A.HR_ENT,
		ROW_NUMBER () OVER (ORDER BY A.HR_ENT DESC, A.CD_NF DESC, A.CD_FILIAL, A.CD_NF ) LINHA,
		A.QT_IT,
		A.VLR_PRC_CUSTO
		INTO #TMP_TBL_ENT
	FROM 
		V_EST_NF_ENT A
		INNER JOIN #TMP_ENT B ON
		A.CD_PROD = B.CD_PROD AND
		A.DT_ENT = B.DT_ULT_ENT
	WHERE
		A.CD_EMP=@CD_EMP
		AND A.TP_MOV_OP_TRANSA = 0
		AND A.TP_MOV=0 ;
   
	SELECT 
		CD_PROD,
		COUNT(*) QTDE
		INTO #TBL_PROD_DPL
	FROM 
		#TMP_TBL_ENT
	GROUP BY CD_PROD
	HAVING COUNT(*)> 1;
  
    --Remove entradas duplicadas - mesmo dia...
	WHILE EXISTS (SELECT  A.CD_PROD, 
						COUNT(*) QTDE
					FROM 
						#TBL_PROD_DPL A
						INNER JOIN #TMP_TBL_ENT B ON 
						A.CD_PROD = B.CD_PROD
					GROUP BY 
						A.CD_PROD
					HAVING COUNT(*)> 1)
	BEGIN

		DELETE FROM E
		FROM 
		#TMP_TBL_ENT E
		INNER JOIN (SELECT  
						A.CD_PROD,
						MAX(B.LINHA) LINHA,
						COUNT(*) QTDE
					FROM 
						#TBL_PROD_DPL A
						INNER JOIN #TMP_TBL_ENT B ON 
						A.CD_PROD = B.CD_PROD
					GROUP BY 
						A.CD_PROD
					HAVING COUNT(*)> 1) B ON 
		E.CD_PROD = B.CD_PROD AND
		E.LINHA   = B.LINHA; 
	END
  

/*******************************************************************************************************************/
-- Backup das entradas anteriores
/*******************************************************************************************************************/
 
	SELECT * 
	INTO EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT_BKP  
	FROM 
		EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT ; 

	SELECT   * 
	INTO EST_PROD_ENT_GRP_ECON_BKP
	FROM 
		EST_PROD_ENT_GRP_ECON;   

	TRUNCATE TABLE EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT
	DELETE FROM EST_PROD_ENT_GRP_ECON;
	
	
/*******************************************************************************************************************/
-- Insere as ulitmas entradas
/*******************************************************************************************************************/
 
	INSERT INTO EST_PROD_ENT_GRP_ECON (CD_EMP, CD_PROD, VLR_IT, VLR_ICMS_IT,VLR_DESC_IT, 
										PERC_ICMS, PERC_IVA, VLR_ICMS_SUBST_IT, VLR_CUSTO_IT,ORIG_LANC)
	
	SELECT 
	DISTINCT A.CD_EMP, A.CD_PROD, A.VLR_IT, A.VLR_ICMS_IT,A.VLR_DESC_IT, 
			A.ALIQ_ICMS, A.PERC_IVA, A.VLR_ICMS_SUBS_IT , A.VLR_PRC_CUSTO,0
     
	FROM 
		EST_NF_ENT A INNER JOIN EST_NF_ENT_IT I ON
		A.CD_EMP = I.CD_EMP AND
		A.CD_FILIAL = I.CD_FILIAL AND
		A.CD_NF = I.CD_NF 
		LEFT JOIN EST_PROD_ENT_GRP_ECON  G ON 
		I.CD_EMP = G.CD_EMP AND
		I.CD_PROD = G.CD_PROD
		INNER JOIN #TMP_TBL_ENT E ON
		I.CD_EMP = E.CD_EMP AND
		I.CD_NF  = E.CD_NF AND
		I.CD_FILIAL = E.CD_FILIAL AND
		I.CD_PROD = E.CD_PROD

	WHERE
		G.CD_EMP IS NULL ; 	
	
    
	INSERT INTO EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT (CD_EMP,CD_FILIAL,CD_NF,CD_PROD)
	SELECT 
		E.CD_EMP,
		E.CD_FILIAL,
		E.CD_NF,
		E.CD_PROD 
	FROM 
		#TMP_TBL_ENT E 
		LEFT JOIN EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT G ON 
		E.CD_EMP = G.CD_EMP AND 
		E.CD_PROD = G.CD_PROD
	WHERE
		G.CD_EMP IS NULL;  
		

/*******************************************************************************************************************/
-- Devolve as ulitmas entradas de produtos que nao encontrou a partir do parametro de data
/*******************************************************************************************************************/

	INSERT INTO EST_PROD_ENT_GRP_ECON
	SELECT   
		A.* 
	FROM 
		EST_PROD_ENT_GRP_ECON_BKP A
		LEFT JOIN EST_PROD_ENT_GRP_ECON  B ON
		A.CD_EMP=B.CD_EMP AND  
		A.CD_PROD =B.CD_PROD
	WHERE 
		B.CD_EMP IS NULL

	INSERT INTO EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT
	SELECT A.* 
	FROM
		EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT_BKP A
		LEFT JOIN EST_PROD_ENT_GRP_ECON_EST_NF_ENT_IT  B ON
		A.CD_EMP=B.CD_EMP AND  
		A.CD_PROD =B.CD_PROD
	WHERE 
		B.CD_EMP IS NULL;
    
/*******************************************************************************************************************/
-- Atualiza o custo.
/*******************************************************************************************************************/ 
	UPDATE A
	SET
		VLR_CUSTO = B.VLR_CUSTO_IT
	FROM 
		EST_PROD_CPL A
		INNER JOIN EST_PROD_ENT_GRP_ECON  B ON
		A.CD_EMP = B.CD_EMP AND
		A.CD_PROD = B.CD_PROD
	WHERE 
		VLR_CUSTO<=0;
		
/*******************************************************************************************************************/